from __future__ import annotations
import asyncio
import random

from enum import Enum

import pygame as pg
import mp
import queue

EVENT_HIDE_SCORE = pg.USEREVENT + 1

class GameState(Enum):
    INTRO   = 1,
    PLAY    = 2,
    SCORE   = 3,
    END     = 4

class Direction(Enum):
    N = 0,
    E = 1,
    S = 2,
    W = 3


state = GameState.INTRO
WELCOME_LINE = mp.ScrollText("    Stiskni START", 10)

class ChainLink:
    def __init__(self, x: int = 0, y: int = 0):
        self.x = x
        self.y = y

class Player:
    x = 10
    y = 10
    chain = queue.Queue()
    chain.put(ChainLink(10,11))
    direction = Direction.N

    def moveUp(self):
        if self.y >=1:
            self.chain.put(ChainLink(self.x,self.y))
            self.chain.get()
            self.y += -1
            self.direction = Direction.N
    def moveDown(self):
        if self.y < mp.PIXELS_HEIGHT-1:
            self.chain.put(ChainLink(self.x,self.y))
            self.chain.get()
            self.y += 1
            self.direction = Direction.S
    def moveLeft(self):
        if self.x >=1:
            self.chain.put(ChainLink(self.x,self.y))
            self.chain.get()
            self.x += -1
            self.direction = Direction.W
    def moveRight(self):
        if self.x < mp.PIXELS_WIDTH-1:
            self.chain.put(ChainLink(self.x,self.y))
            self.chain.get()
            self.x += 1
            self.direction = Direction.E
    def enlarge(self):
        self.chain.put(ChainLink(self.x,self.y))
    def draw(self):
        mp.draw_pixel(self.x, self.y, "darkblue") #head
        for item in list(self.chain.queue): #body = chain
            mp.draw_pixel(item.x, item.y, "blue")

class Food:
    x = 0
    y = 0
    def draw(self):
        mp.draw_pixel(self.x, self.y, "red")
    def toss(self):
        self.x = random.randint(0, mp.PIXELS_WIDTH - 1)
        self.y = random.randint(0, mp.PIXELS_WIDTH - 1)
        print(f"Food placed at: {self.x},{self.y}")

def isPlayerEatingFood(p,food):
    return p.x == food.x and p.y == food.y

player = Player()
food = Food()

def game_intro():
    global state

    mp.fill("black")
    mp.draw_pixel_text_scroll(0, 8, "white", WELCOME_LINE)

    keys = pg.key.get_pressed()
    if keys[pg.K_q]:
        return False
    if keys[pg.K_s]:
        state = GameState.PLAY
        food.toss()

    for event in pg.event.get():
        if event.type == pg.QUIT:
            return False
    return True


def game_play():
    global state
    mp.fill("black")
    food.draw()
    player.draw()

    for event in pg.event.get():
        if event.type == pg.QUIT:
            return False
        if event.type == pg.KEYDOWN and event.key == pg.K_q:
            return False
        if event.type == pg.KEYDOWN and event.key == pg.K_UP and not player.direction == Direction.S:
            player.moveUp()
        if event.type == pg.KEYDOWN and event.key == pg.K_DOWN and not player.direction == Direction.N:
            player.moveDown()
        if event.type == pg.KEYDOWN and event.key == pg.K_LEFT and not player.direction == Direction.E:
            player.moveLeft()
        if event.type == pg.KEYDOWN and event.key == pg.K_RIGHT and not player.direction == Direction.W:
            player.moveRight()

    if isPlayerEatingFood(player, food):
        player.enlarge()
        food.toss()
        state = GameState.SCORE
        mp.set_timer(EVENT_HIDE_SCORE, 250)

    return True

def game_score():
    global state
    mp.fill("black")
    mp.draw_rainbow()
    mp.draw_pixel_text(7, 8,"white" , f"{player.chain.qsize()}")
    for event in pg.event.get():
        if event.type == pg.QUIT:
            return False
        if event.type == EVENT_HIDE_SCORE:
            mp.set_timer(EVENT_HIDE_SCORE, 0)
            state = GameState.PLAY
    return True


def game_loop():
    if state == GameState.INTRO:
        running = game_intro()
    if state == GameState.PLAY:
        running = game_play()
    if state == GameState.SCORE:
        running = game_score()
    return running

mp.start(game_loop,"172.16.128.22")
