from __future__ import annotations

import pygame as pg
import sys
import asyncio
import socket

VERSION = "20250429.1"

CHARSET = {
    ' ': [
        "     ",
        "     ",
        "     ",
        "     ",
        "     "
    ],
    'A': [
        "  #  ",
        " # # ",
        " ### ",
        " # # ",
        " # # "
    ],
    'B': [
        " ##  ",
        " # # ",
        " ##  ",
        " # # ",
        " ##  "
    ],
    'C': [
        "  ## ",
        " #   ",
        " #   ",
        " #   ",
        "  ## "
    ],
    'D': [
        " ##  ",
        " # # ",
        " # # ",
        " # # ",
        " ##  "
    ],
    'E': [
        " ### ",
        " #   ",
        " ##  ",
        " #   ",
        " ### "
    ],
    'F': [
        " ### ",
        " #   ",
        " ##  ",
        " #   ",
        " #   "
    ],
    'G': [
        "  ## ",
        " #   ",
        " # # ",
        " # # ",
        "  ## "
    ],
    'H': [
        " # # ",
        " # # ",
        " ### ",
        " # # ",
        " # # "
    ],
    'I': [
        " ### ",
        "  #  ",
        "  #  ",
        "  #  ",
        " ### "
    ],
    'J': [
        "  ### ",
        "    # ",
        "    # ",
        " #  # ",
        "  ##  "
    ],
    'K': [
        " # # ",
        " # # ",
        " ##  ",
        " # # ",
        " # # "
    ],
    'L': [
        " #   ",
        " #   ",
        " #   ",
        " #   ",
        " ### "
    ],
    'M': [
        " # # ",
        " ### ",
        " # # ",
        " # # ",
        " # # "
    ],
    'N': [
        "     ",
        "     ",
        " ##  ",
        " # # ",
        " # # "
    ],
    'O': [
        "  #  ",
        " # # ",
        " # # ",
        " # # ",
        "  #  "
    ],
    'P': [
        " ##  ",
        " # # ",
        " ##  ",
        " #   ",
        " #   "
    ],
    'Q': [
        "  #  ",
        " # # ",
        " # # ",
        " # # ",
        "  ## "
    ],
    'R': [
        " ##  ",
        " # # ",
        " ##  ",
        " # # ",
        " # # "
    ],
    'S': [
        "  ## ",
        " #   ",
        "  #  ",
        "   # ",
        " ##  "
    ],
    'T': [
        " ### ",
        "  #  ",
        "  #  ",
        "  #  ",
        "  #  "
    ],
    'U': [
        " # # ",
        " # # ",
        " # # ",
        " # # ",
        "  ## "
    ],
    'V': [
        " # # ",
        " # # ",
        " # # ",
        "  #  ",
        "  #  "
    ],
    'W': [
        " # # ",
        " # # ",
        " # # ",
        " ### ",
        " # # "
    ],
    'X': [
        " # # ",
        " # # ",
        "  #  ",
        " # # ",
        " # # "
    ],
    'Y': [
        " # # ",
        " # # ",
        "  #  ",
        "  #  ",
        "  #  "
    ],
    'Z': [
        " ### ",
        "   # ",
        "  #  ",
        " #   ",
        " ### "
    ],
    '1': [
        "  #  ",
        " ##  ",
        "  #  ",
        "  #  ",
        " ### "
    ],
    '2': [
        " ### ",
        "   # ",
        " ### ",
        " #   ",
        " ### "
    ],
    '3': [
        " ### ",
        "   # ",
        "  ## ",
        "   # ",
        " ### "
    ],
    '4': [
        " # # ",
        " # # ",
        " ### ",
        "   # ",
        "   # "
    ],
    '5': [
        " ### ",
        " #   ",
        " ### ",
        "   # ",
        " ### "
    ],
    '6': [
        " ### ",
        " #   ",
        " ### ",
        " # # ",
        " ### "
    ],
    '7': [
        " ### ",
        "   # ",
        "  #  ",
        "  #  ",
        "  #  "
    ],
    '8': [
        " ### ",
        " # # ",
        " ### ",
        " # # ",
        " ### "
    ],
    '9': [
        " ### ",
        " # # ",
        " ### ",
        "   # ",
        " ### "
    ],
    '0': [
        " ### ",
        " # # ",
        " # # ",
        " # # ",
        " ### "
    ],
    '!': [
        "  #  ",
        "  #  ",
        "  #  ",
        "     ",
        "  #  "
    ],
    '.': [
        "     ",
        "     ",
        "     ",
        "     ",
        "  #  "
    ],
    ':': [
        "     ",
        "  #  ",
        "     ",
        "  #  ",
        "     "
    ],
    '?': [
        " ### ",
        "   # ",
        "  #  ",
        "     ",
        "  #  "
    ]
}


PIXEL_SIZE = 30
PIXEL_PADDING = 3
PIXEL_CHAR_WIDTH = 4
PIXEL_CHAR_HEIGHT = 5
PIXELS_WIDTH = 20
PIXELS_HEIGHT = 20
FPS = 20
DISPLAY_PIXEL_NUMBERS = False
WLED_UDP_PORT = 21324
PIXEL_HOST = None
STREAM_MAX_FRAMES_PER_SECOND = 20
FB = bytearray(PIXELS_WIDTH * PIXELS_HEIGHT * 3) #RGB frame buffer
LAST_FB = bytearray(FB)


class ScrollText:
    def __init__(self, text:str, speed_px_per_second:int):
        self.last_time = 0
        self.delay = 0.0
        self.text = text
        self.index = 0
        self.speed = speed_px_per_second
    def shiftLeft(self):
        current_time = pg.time.get_ticks()
        if self.last_time != 0:
            delta_time = (current_time - self.last_time) 
            self.delay += delta_time
            speed_ratio = 1000 / self.speed
            if self.delay > speed_ratio:
                self.delay -= speed_ratio
                self.index+=1
        self.last_time = current_time

def draw_pixel(x, y, color):
    global PIXEL_HOST
    global PIXELS_WIDTH
    global FB

    if x < 0 or x >= PIXELS_WIDTH or y < 0 or y >= PIXELS_HEIGHT:
        return

    new_x = PIXELS_HEIGHT - y - 1
    new_y = x

    if not (x % 2 == 0):
        new_x = y
    
    new_y = PIXELS_HEIGHT - new_y - 1
    new_x = PIXELS_WIDTH - new_x - 1

    # print (f"x = {x}, y={y}")

    #led_index = (y * PIXELS_WIDTH * 3) + x * 3
    led_index = (new_y * PIXELS_WIDTH * 3) + new_x * 3


    if PIXEL_HOST:
        c = pg.Color(color)

        FB[led_index + 0] = c.r
        FB[led_index + 1] = c.g
        FB[led_index + 2] = c.b
    pg.draw.rect (screen,
                      color,
                      [ x * (PIXEL_SIZE + PIXEL_PADDING) , y * (PIXEL_SIZE + PIXEL_PADDING) , 
                        PIXEL_SIZE, PIXEL_SIZE
                      ],
                      0)
    if DISPLAY_PIXEL_NUMBERS:
        color = "red"
        if x % 2 == 0:
            color = "blue"

        text_surface = my_font.render(f"{new_x},{new_y}", False, "white")
        screen.blit(text_surface, 
                    (x * (PIXEL_SIZE + PIXEL_PADDING) + PIXEL_SIZE / 2 - text_surface.get_size()[0] / 2 ,
                     y * (PIXEL_SIZE + PIXEL_PADDING) + PIXEL_SIZE / 2 - text_surface.get_size()[1]))

        text_surface = my_font.render(f"{led_index}", False, color)
        screen.blit(text_surface, 
                    (x * (PIXEL_SIZE + PIXEL_PADDING) + PIXEL_SIZE / 2 - text_surface.get_size()[0] / 2 ,
                     y * (PIXEL_SIZE + PIXEL_PADDING) + PIXEL_SIZE / 2 + text_surface.get_size()[1] / 2 ))



def draw_pixel_char(start_x,start_y,color,character:str, offset_x:int = 0):
    bitmap = CHARSET[character.upper()]
    for row in range (0, bitmap.__len__()):
        x = 0
        for col in range (0,bitmap[row].__len__()-1):
            if col >= offset_x:
                pixel_color = "black"
                bit = bitmap[row][col+1];
                if bit == '#':
                    pixel_color = color
                draw_pixel(start_x + x, start_y + row, pixel_color)
                x+=1


def draw_pixel_text(start_x,start_y,color, text:str, offset_x:int = 0, word_wrap = True ):
    x = start_x
    y = start_y
    text_to_show = text
    if offset_x != 0:
        offset_x = offset_x % (text.__len__() * PIXEL_CHAR_WIDTH)
        removed_letters =  int (offset_x / PIXEL_CHAR_WIDTH)
        text_to_show = text_to_show[removed_letters:]
        offset_x = offset_x % PIXEL_CHAR_WIDTH

    for i in range (0,text_to_show.__len__()):
        if text_to_show[i] == '\n':
            if not word_wrap:
                return
            x = start_x
            y += PIXEL_CHAR_HEIGHT + 1
            continue
        if x >= PIXELS_WIDTH:
            if not word_wrap:
                return
            x  = 0
            y += PIXEL_CHAR_HEIGHT + 1
        if y < PIXELS_HEIGHT:
            if i == 0:
                draw_pixel_char(x,y,color,text_to_show[i], offset_x)
                x += PIXEL_CHAR_WIDTH - offset_x
            else:
                draw_pixel_char(x,y,color,text_to_show[i])
                x += PIXEL_CHAR_WIDTH

def draw_pixel_text_scroll(start_x,start_y,color, stext:ScrollText):
    draw_pixel_text(start_x, start_y, color, stext.text, stext.index, word_wrap=False)
    stext.shiftLeft()

def draw_rainbow():
    for y in range (0,PIXELS_HEIGHT):
        for x in range (0,PIXELS_WIDTH):
            rgb = ( x*10, y*10, 0)
            draw_pixel(x,y,rgb)

def fill(color = "black"):
    for y in range (0,PIXELS_HEIGHT):
        for x in range (0,PIXELS_WIDTH):
            draw_pixel(x,y,color)

def running_in_browser():
    print(f"Running on: {sys.platform}")
    return (sys.platform == "emscripten")

def send_frame():
    global FB
    global LAST_FB
    if LAST_FB != FB:
        PACKET = bytearray([0x02, 0x05]) + FB
        LAST_FB = bytearray(FB)
        # print (f"packet:{PACKET}")
        print ("Sending frame")
        sock.sendto(PACKET, (PIXEL_HOST, WLED_UDP_PORT))
    # else:
        # print ("Not sending frame")


async def loop(game_loop):
    global state
    global PIXEL_HOST
    last_frame_streamed = 0

    if PIXEL_HOST:
        global sock
        sock = socket.socket(socket.AF_INET, socket.SOCK_DGRAM)

    clock = pg.time.Clock()

    pg.display.set_caption("GAME")
    running = True
    while running:
        if pg.event.peek(eventtype=pg.QUIT):
            break
        running = game_loop()
        if PIXEL_HOST:
            current_tick = pg.time.get_ticks() 
            if last_frame_streamed == 0 or (current_tick - last_frame_streamed) > 1000/STREAM_MAX_FRAMES_PER_SECOND:
                last_frame_streamed = current_tick 
                send_frame()
            
        pg.display.flip()
        clock.tick(FPS)
        await asyncio.sleep(0)

def set_timer(event: int, millis: int, loops: int = 0):
    if not running_in_browser():
        pg.time.set_timer(event,millis,loops)
    else:
        import pyodide
        pyodide.code.run_js(f"pygame_setTimer({event},{millis},{loops});")

def fire_timer(event: int):
    pg.event.post(pg.event.Event(int(event)))

def get_keys_pressed():
    return pg.key.get_pressed()

def get_events():
    events = pg.event.get()
    return events

def sub_init():
    print("sub_init")

    global screen
    global my_font

    pg.init()
    screen = pg.display.set_mode(size = 
            (
                (PIXEL_SIZE + PIXEL_PADDING) * PIXELS_WIDTH,
                (PIXEL_SIZE + PIXEL_PADDING) * PIXELS_HEIGHT
            )
        )
    pg.font.init()
    my_font = pg.font.SysFont(pg.font.get_default_font(), 15)
    pg.key.set_repeat(200,50) #keyboard presses

def init_sync(game_loop):
    sub_init()
    asyncio.get_event_loop().run_until_complete(loop(game_loop))

async def init_async(game_loop):
    sub_init()
    await loop(game_loop)
    pg.quit()

def start(game_loop, host = None):
    if not running_in_browser():
        global PIXEL_HOST
        PIXEL_HOST = host
        print("Not running in browser...")
        asyncio.run(init_async(game_loop))
        exit()
    print("Running in browser...")
    init_sync(game_loop)
    
